/*! \file tlk_cert_api_sst.h 
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_api_sst.h 
*
* Project, Target, subsystem:   Toolkit, Certificate Handling
* 
* Created:                      29.01.2008
*
* Modified:                     29.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_API_SST_H_
#define _TLK_CERT_API_SST_H_
#include "tlk_cert_types.h"
/**
* @brief    This a main function which covers all the steps discussed above. It will go through every 
*           field in the certificate structure and will perform validation according to the step and data 
*           which is stored in the context object. The user will be responsible to provide the context object, 
*           which will be an input for the every step. . (See requirement CVP_2_1).
*           Also this object will be protected cryptographically (MAC) or will be allocated in the 
*           trust environment. (See requirement CVP_2_2).
* @note     User is responsible for contextObject_ptr (It is MAC protected)
*           This function has functionality equivalent to the TLK_CERT_ChainValidationProcess. The main 
*           difference between these functions is the source of the certificate to be processed (User will
*           pass it or it will be read from secured environment).
*
* @param contextObject_ptr         [in/out]  - Pointer to the context object
* @param sstAccessParams           [in]      - Parameters which are necessary for SST Access
*
* @return TLK_CERT_RC_OK	                 - The operation completed successfully.
* @return TLK_CERT_RC_FAIL                   - The operation failed.
*/
DxError_t TLK_CERT_SST_ChainValidationProcess(              const   TLK_CERT_ContextObj_t       *contextObject_ptr,
                                                                    TLK_CERT_SstAccessParams_t   sstAccessParams);


/**
* @brief    This API will insert the given certificate into SST.
*
* @param currCertificate_ptr    [in]        - Pointer to the certificate which will be inserted into SST 
* @param paramsForSstAccess_ptr [in/out]    - Pointer to the data structure, which contains all necessary data for SST access.
*
* @return TLK_CERT_RC_OK	                 - The operation completed successfully.
* @return TLK_CERT_RC_FAIL                   - The operation failed.
*/
DxError_t TLK_CERT_SST_CertificateInsert(                   const   TLK_CERT_Buffer_t           *currCertificate_ptr,
                                                                    TLK_CERT_SstAccessParams_t  *paramsForSstAccess_ptr);

#endif
